local raveChildren
local t = Def.ActorFrame {};
t[#t+1] = EXF_ScreenEvaluation();
	
t[#t+1] = LoadActor("_eval display") .. {
		InitCommand=cmd(diffusealpha,1;);
	};
	
if not GAMESTATE:IsCourseMode() then
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+160);
	OnCommand=cmd(diffusealpha,0;zoomy,0;sleep,0.5;decelerate,0.4;diffusealpha,1;zoomy,1);
	OffCommand=cmd(decelerate,0.2;zoomy,0;diffusealpha,0;);
	Def.Sprite {
		name="SongBanner";
		OnCommand=function(self) 
			 local song =GAMESTATE:GetCurrentSong(); 
				if song then
					if song:HasBanner() then
						self:Load(song:GetBannerPath()):scaletoclipped(256,80)
					else
						self:Load(THEME:GetPathG("Common fallback", "banner")):scaletoclipped(256,80)
					end
					self:zoom(0.75)
				else
					self:diffusealpha(0)
			end
		end;
	};
	LoadActor(THEME:GetPathG("ScreenEvaluationSummary", "BannerFrame")) .. {
		InitCommand=cmd(zoom,0.75);
	};
};		

else

t[#t+1] = LoadFont("Common Normal") .. {
		InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-60;zoom,0.5;diffuse,color("#C4E9F5");strokecolor,color("#4A7280"););
		OnCommand=cmd(diffusealpha,0;sleep,0.3;smooth,0.3;diffusealpha,1.0;);
		OffCommand=cmd(smooth,0.2;zoomx,0.7;diffusealpha,0;);
		Text=GAMESTATE:GetCurrentCourse():GetDisplayFullTitle()
	};
	
end;

if gameplay_pause_count > 0 then
	t[#t+1]= Def.BitmapText{
		Font= "_troika 24px",
		Text= THEME:GetString("PauseMenu", "pause_count") .. ": " .. gameplay_pause_count,
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+116;diffuse,color("#E8BE84");strokecolor,color("#000000");zoom,0.75);
		OnCommand=cmd(diffusealpha,0;sleep,0.3;smooth,0.3;diffusealpha,1.0;);
		OffCommand=cmd(smooth,0.2;zoomx,0.7;diffusealpha,0;);
	}
end

t[#t+1] = Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#000000");diffusealpha,0;);
			OffCommand=cmd(sleep,1.2;decelerate,0.4;diffusealpha,1;sleep,0.2;);
		};
	};

t[#t+1] = Def.ActorFrame {
		Def.ActorFrame{
		Name="RaveMessages";
		InitCommand=function(self)
			raveChildren = self:GetChildren()
			self:visible(GAMESTATE:GetPlayMode() == 'PlayMode_Rave')

			raveChildren.P1Win:visible(false)
			raveChildren.P2Win:visible(false)
			raveChildren.Draw:visible(false)
		end;
		OnCommand=function(self)
			local p1Win = GAMESTATE:IsWinner(PLAYER_1)
			local p2Win = GAMESTATE:IsWinner(PLAYER_2)

			if GAMESTATE:IsWinner(PLAYER_1) then
				raveChildren.P1Win:visible(true)
			elseif GAMESTATE:IsWinner(PLAYER_2) then
				raveChildren.P2Win:visible(true)
			else
				raveChildren.Draw:visible(true)
			end
		end;

		LoadActor(THEME:GetPathG("_rave result","P1"))..{
			Name="P1Win";
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;);
			OnCommand=function(self)
				self:diffusealpha(0):zoom(1):smooth(0.6):zoom(0.75):diffusealpha(1):sleep(1):decelerate(0.6):addy(70):zoom(0.25)
			end;
			OffCommand=cmd(decelerate,0.3;diffusealpha,0);
		};
		LoadActor(THEME:GetPathG("_rave result","P2"))..{
			Name="P2Win";
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;);
			OnCommand=function(self)
				self:diffusealpha(0):zoom(1):smooth(0.6):zoom(0.75):diffusealpha(1):sleep(1):decelerate(0.6):addy(70):zoom(0.25)
			end;
			OffCommand=cmd(decelerate,0.3;diffusealpha,0);		
		};
		LoadActor(THEME:GetPathG("_rave result","draw"))..{
			Name="Draw";
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;);
			OnCommand=function(self)
				self:diffusealpha(0):zoom(1):smooth(0.6):zoom(0.75):diffusealpha(1):sleep(1):decelerate(0.6):addy(70):zoom(0.25)
			end;
			OffCommand=cmd(decelerate,0.3;diffusealpha,0);
		};
	};
};
		
return t